/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_CUI_SOURCE_INC_CUISRCHDLG_HXX
#define INCLUDED_CUI_SOURCE_INC_CUISRCHDLG_HXX

#include <svtools/stdctrl.hxx>
#include <vcl/combobox.hxx>
#include <vcl/edit.hxx>
#include <vcl/lstbox.hxx>
#include <vcl/button.hxx>
#include <vcl/group.hxx>
#include <vcl/fixed.hxx>
#include <vcl/dialog.hxx>
#include <sfx2/childwin.hxx>
#include <sfx2/basedlgs.hxx>
#include <svtools/svmedit.hxx>
#include <svl/srchdefs.hxx>

class SvxJSearchOptionsPage;

class SvxJSearchOptionsDialog : public SfxSingleTabDialog
{
    sal_Int32                     nInitialTlFlags;
    VclPtr<SvxJSearchOptionsPage> pPage;

    SvxJSearchOptionsDialog( const SvxJSearchOptionsDialog & ) SAL_DELETED_FUNCTION;
    SvxJSearchOptionsDialog & operator == ( const SvxJSearchOptionsDialog & ) SAL_DELETED_FUNCTION;

public:
    SvxJSearchOptionsDialog(vcl::Window *pParent,
        const SfxItemSet& rOptionsSet, sal_Int32 nInitialFlags);
    virtual ~SvxJSearchOptionsDialog();
    virtual void dispose() SAL_OVERRIDE;

    // Window
    virtual void    Activate() SAL_OVERRIDE;

    sal_Int32           GetTransliterationFlags() const;
};

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
