/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#ifndef INCLUDED_EXTENSIONS_SOURCE_DBPILOTS_COMMONPAGESDBP_HXX
#define INCLUDED_EXTENSIONS_SOURCE_DBPILOTS_COMMONPAGESDBP_HXX

#include "controlwizard.hxx"
#include <vcl/fixed.hxx>
#include <vcl/lstbox.hxx>
#include <com/sun/star/sdb/XDatabaseContext.hpp>


namespace dbp
{

    class OTableSelectionPage : public OControlWizardPage
    {
    protected:
        VclPtr<FixedText>       m_pDatasourceLabel;
        VclPtr<ListBox>         m_pDatasource;
        VclPtr<PushButton>      m_pSearchDatabase;
        VclPtr<ListBox>         m_pTable;

        ::com::sun::star::uno::Reference< ::com::sun::star::sdb::XDatabaseContext >
                        m_xDSContext;

    public:
        OTableSelectionPage(OControlWizard* _pParent);
        virtual ~OTableSelectionPage();
        virtual void dispose() SAL_OVERRIDE;

    protected:
        // TabPage overridables
        void ActivatePage() SAL_OVERRIDE;

        // OWizardPage overridables
        virtual void        initializePage() SAL_OVERRIDE;
        virtual bool        commitPage( ::svt::WizardTypes::CommitPageReason _eReason ) SAL_OVERRIDE;

    protected:
        DECL_LINK( OnListboxSelection, ListBox* );
        DECL_LINK( OnListboxDoubleClicked, ListBox* );
        DECL_LINK( OnSearchClicked, PushButton* );

        void implCollectDatasource();
        void implFillTables(const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >&
                        _rxConn = ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >());

        // OControlWizardPage overridables
        virtual bool    canAdvance() const SAL_OVERRIDE;
    };

    class OMaybeListSelectionPage : public OControlWizardPage
    {
    protected:
        VclPtr<RadioButton>    m_pYes;
        VclPtr<RadioButton>    m_pNo;
        VclPtr<ListBox>        m_pList;

    public:
        OMaybeListSelectionPage( OControlWizard* _pParent, const OString& _rID, const OUString& _rUIXMLDescription );
        virtual ~OMaybeListSelectionPage();
        virtual void dispose() SAL_OVERRIDE;

    protected:
        DECL_LINK( OnRadioSelected, RadioButton* );

        // TabPage overridables
        void ActivatePage() SAL_OVERRIDE;

        // own helper
        void    announceControls(
            RadioButton& _rYesButton,
            RadioButton& _rNoButton,
            ListBox& _rSelection);

        void implEnableWindows();

        void implInitialize(const OUString& _rSelection);
        void implCommit(OUString& _rSelection);
    };

    class ODBFieldPage : public OMaybeListSelectionPage
    {
    protected:
        VclPtr<FixedText>      m_pDescription;
        VclPtr<RadioButton>    m_pStoreYes;
        VclPtr<RadioButton>    m_pStoreNo;
        VclPtr<ListBox>        m_pStoreWhere;

    public:
        ODBFieldPage( OControlWizard* _pParent );
        virtual ~ODBFieldPage();
        virtual void dispose() SAL_OVERRIDE;

    protected:
        void setDescriptionText(const OUString& _rDesc) { m_pDescription->SetText(_rDesc); }

        // OWizardPage overridables
        virtual void initializePage() SAL_OVERRIDE;
        virtual bool commitPage( ::svt::WizardTypes::CommitPageReason _eReason ) SAL_OVERRIDE;

        // own overridables
        virtual OUString& getDBFieldSetting() = 0;
    };


}   // namespace dbp



#endif // INCLUDED_EXTENSIONS_SOURCE_DBPILOTS_COMMONPAGESDBP_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
