#!/usr/bin/python

import os
import commands

locales = {}
locales['ar'] = 'ar'
locales['bn-BD'] = 'bn'
locales['cs'] = 'cs'
locales['da'] = 'da'
locales['de'] = 'de'
locales['el'] = 'el'
locales['en-GB'] = 'en-gb'
locales['en-US'] = 'en-us'
locales['es-ES'] = 'es'
locales['fi'] = 'fi'
locales['fr'] = 'fr'
locales['he'] = 'he'
locales['hu'] = 'hu'
locales['id'] = 'id'
locales['it'] = 'it'
locales['ja'] = 'ja'
locales['ko'] = 'ko'
locales['nb-NO'] = 'nb'
locales['nl'] = 'nl'
locales['nn-NO'] = 'nn'
locales['pl'] = 'pl'
locales['pt-PT'] = 'pt'
locales['pt-BR'] = 'pt-br'
locales['ro'] = 'ro'
locales['ru'] = 'ru'
locales['sv-SE'] = 'sv'
locales['tr'] = 'tr'
locales['uk'] = 'uk'
locales['zh-CN'] = 'zh'

if "64" in commands.getoutput("getconf LONG_BIT"):
        archi="linux-x86_64"
else:
        archi="linux-i686"

os.system('mkdir -p output')
os.system('rm -rf output/thunderbird-l10n-*')
os.system('wget --quiet http://ftp.mozilla.org/pub/thunderbird/releases/latest/MD5SUMS -O MD5SUMS')
urls = commands.getoutput("grep linux MD5SUMS | grep tar.bz2 | grep -v tar.bz2.asc | awk {'print $2;'}")
for url in urls.split("\n"):
        downloadurl = "http://ftp.mozilla.org/pub/thunderbird/releases/latest/%s" % (url)
        urlelements = url.split('/')
        arch = urlelements[0]
        locale = urlelements[1]
        if locale in locales and arch == archi:
                lang = locales[locale]
                print "Downloading locale %s for %s" % (locale, arch)
                os.system("mkdir -p output/thunderbird-l10n-%s" % (lang))
                os.chdir("output/thunderbird-l10n-%s" % (lang))
                os.system("wget --quiet %s -O thunderbird.tar.bz2" % (downloadurl))
                os.system("bzip2 -d thunderbird.tar.bz2")
                os.system("tar xf thunderbird.tar")
                os.system("rm thunderbird.tar")
                os.system("mkdir -p opt/thunderbird")
                os.system("mv thunderbird/omni.ja opt/thunderbird/omni.ja")
                os.system("rm -rf thunderbird")
                os.chdir("../../")
	else:
		print "Ignored locale %s and arch %s in URL %s" % (locale, arch, url)

for locale in locales:
        if not os.path.exists("output/thunderbird-l10n-%s/opt/thunderbird/omni.ja" % locales[locale]):
                print "WARNING!! NO ARCHIVE FOUND FOR LOCALE %s" % locale

os.system("rm -rf MD5SUMS")



